/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.config;

import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.util.Util;

public class ConfigLoader {
    private static final List<Field> data = new ArrayList<Field>();
    public Configuration config;

    public ConfigLoader(File directory) {
        boolean needSave;
        if (!directory.exists() && !directory.mkdir()) {
            return;
        }
        File file = new File(directory, "CustomNpcs Unofficial.cfg");
        ArrayList<String> lines = new ArrayList<String>();
        boolean isOldVersion = false;
        boolean bl = needSave = !file.exists();
        if (!needSave) {
            String text = Util.instance.loadFile(file);
            boolean bl2 = isOldVersion = text.indexOf("# Configuration file") != 0;
            if (isOldVersion) {
                String[] stringArray = text.split("\n");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String line = stringArray[i];
                    if (!line.contains("=") || line.indexOf("#") == 0) continue;
                    lines.add(line);
                }
                Util.instance.saveFile(file, "");
            }
        }
        this.config = new Configuration(file);
        for (Field field : CustomNpcs.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProp.class)) continue;
            ConfigProp prop = field.getAnnotation(ConfigProp.class);
            String name = field.getName();
            ConfigCategory cat = this.config.getCategory(prop.type());
            Property property = null;
            String classType = field.getType().getTypeName().toLowerCase().replace("integer", "int").replace("[]", "");
            if (classType.lastIndexOf(".") != -1) {
                classType = classType.substring(classType.lastIndexOf(".") + 1);
            }
            if (cat.containsKey(name)) {
                property = cat.get(name);
                if (property.getType() == Property.Type.COLOR) {
                    if (!property.getString().isEmpty() && property.getString().length() != 6) {
                        if (property.getString().length() > 6) {
                            Color color = new Color((int)Long.parseLong(property.getString(), 16));
                            property.set(Integer.toHexString(color.getRGB()).toUpperCase());
                        } else {
                            StringBuilder str = new StringBuilder(property.getString());
                            while (str.length() < 6) {
                                str.insert(0, "0");
                            }
                            property.set(str.toString().toUpperCase());
                        }
                        needSave = true;
                    } else if (property.getStringList().length > 0) {
                        ArrayList<String> list = new ArrayList<String>();
                        boolean change = false;
                        for (String c : property.getStringList()) {
                            if (c.length() > 6) {
                                change = true;
                                Color color = new Color((int)Long.parseLong(c, 16));
                                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
                                StringBuilder str = new StringBuilder(Integer.toHexString(color.getRGB()).toUpperCase());
                                while (str.length() < 6) {
                                    str.insert(0, "0");
                                }
                                list.add(str.toString().toUpperCase());
                                continue;
                            }
                            if (c.length() >= 6) continue;
                            change = true;
                            StringBuilder str = new StringBuilder(c);
                            while (str.length() < 6) {
                                str.insert(0, "0");
                            }
                            list.add(str.toString().toUpperCase());
                        }
                        if (change) {
                            property.set(list.toArray(new String[0]));
                            needSave = true;
                        }
                    }
                }
                if (!prop.info().isEmpty()) {
                    property.setComment(prop.info());
                }
                if (!prop.def().isEmpty()) {
                    if (field.getType().isArray()) {
                        property.setValidValues(prop.def().split(","));
                    } else {
                        property.setDefaultValue(prop.def());
                    }
                }
                boolean isContinue = true;
                if (!field.getType().isArray()) {
                    if (!prop.min().isEmpty()) {
                        if (classType.equals("int")) {
                            property.setMinValue(Integer.parseInt(prop.min()));
                        } else if (classType.equals("double")) {
                            property.setMinValue(Double.parseDouble(prop.min()));
                        }
                    }
                    if (!prop.max().isEmpty()) {
                        if (classType.equals("int")) {
                            property.setMaxValue(Integer.parseInt(prop.max()));
                        } else if (classType.equals("double")) {
                            property.setMaxValue(Double.parseDouble(prop.max()));
                        }
                    }
                } else {
                    try {
                        Object objArray = field.get(null);
                        int size = 0;
                        if (objArray instanceof int[]) {
                            size = ((int[])objArray).length;
                        } else if (objArray instanceof Object[]) {
                            size = ((Object[])objArray).length;
                        } else if (objArray instanceof double[]) {
                            size = ((double[])objArray).length;
                        }
                        isContinue = property.getStringList().length == size;
                    }
                    catch (Exception e) {
                        LogWriter.error("Error Load: \"" + field.getName() + "\"", e);
                    }
                }
                if (isContinue) continue;
            }
            needSave = true;
            Object object = null;
            try {
                object = field.get(null);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            Property.Type type = Property.Type.STRING;
            if (field.getType().isArray()) {
                String[] values = null;
                String[] validValues = prop.def().split(",");
                switch (classType) {
                    case "string": {
                        values = (String[])object;
                        break;
                    }
                    case "int": {
                        type = Property.Type.INTEGER;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (int[])object;
                        values = new String[vs.length];
                        for (int i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "boolean": {
                        type = Property.Type.BOOLEAN;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (boolean[])object;
                        values = new String[vs.length];
                        for (int i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "double": {
                        type = Property.Type.DOUBLE;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (double[])object;
                        values = new String[vs.length];
                        for (int i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "color": {
                        type = Property.Type.COLOR;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (Color[])object;
                        values = new String[vs.length];
                        for (int i = 0; i < vs.length; ++i) {
                            Color color = new Color(vs[i].getRGB());
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
                            StringBuilder str = new StringBuilder(Integer.toHexString(color.getRGB()).toUpperCase());
                            while (str.length() < 6) {
                                str.insert(0, "0");
                            }
                            values[i] = str.toString();
                            if (values[i].length() <= 6) continue;
                            values[i] = values[i].substring(values[i].length() - 6);
                        }
                        break;
                    }
                }
                if (values != null) {
                    property = new Property(name, values, type, "config." + name + ".key");
                    property.setValidValues(validValues);
                }
            } else if (object != null) {
                String value = object.toString();
                switch (classType) {
                    case "int": {
                        type = Property.Type.INTEGER;
                        value = object.toString();
                        break;
                    }
                    case "boolean": {
                        type = Property.Type.BOOLEAN;
                        value = object.toString();
                        break;
                    }
                    case "double": {
                        type = Property.Type.DOUBLE;
                        value = object.toString();
                        break;
                    }
                    case "color": {
                        type = Property.Type.COLOR;
                        StringBuilder str = new StringBuilder(Integer.toHexString(((Color)object).getRGB()).toUpperCase());
                        while (str.length() < 6) {
                            str.insert(0, "0");
                        }
                        value = str.toString();
                        if (value.length() <= 6) break;
                        value = value.substring(value.length() - 6);
                    }
                }
                property = new Property(name, value, type, "config." + name + ".key");
                property.setDefaultValue(prop.def());
                if (!prop.min().isEmpty()) {
                    if (classType.equals("int")) {
                        property.setMinValue(Integer.parseInt(prop.min()));
                    } else if (classType.equals("double")) {
                        property.setMinValue(Double.parseDouble(prop.min()));
                    }
                }
                if (!prop.max().isEmpty()) {
                    if (classType.equals("int")) {
                        property.setMaxValue(Integer.parseInt(prop.max()));
                    } else if (classType.equals("double")) {
                        property.setMaxValue(Double.parseDouble(prop.max()));
                    }
                }
            }
            if (property == null) continue;
            if (!prop.info().isEmpty()) {
                property.setComment(prop.info());
            }
            cat.put(name, property);
        }
        if (isOldVersion) {
            for (String line : lines) {
                String name = line.substring(0, line.indexOf("="));
                String value = line.substring(line.indexOf("=") + 1);
                Property property = null;
                if (this.config.getCategory("general").containsKey(name)) {
                    for (String key : this.config.getCategory("general").keySet()) {
                        if (!key.equalsIgnoreCase(name)) continue;
                        property = this.config.getCategory("general").get(key);
                        break;
                    }
                } else if (this.config.getCategory("client").containsKey(name)) {
                    for (String key : this.config.getCategory("client").keySet()) {
                        if (!key.equalsIgnoreCase(name)) continue;
                        property = this.config.getCategory("client").get(key);
                        break;
                    }
                }
                if (property == null) continue;
                if (value.indexOf("[") == 0) {
                    value = value.replace("[", "").replace("]", "");
                    property.setValidValues(value.split(", "));
                    continue;
                }
                if (value.indexOf("{") == 0) {
                    value = value.replace("{", "").replace("}", "");
                    property.setValidValues(value.split(", "));
                    continue;
                }
                property.setValue(value);
            }
            needSave = true;
        }
        if (needSave) {
            this.config.save();
        }
        this.resetData();
    }

    public static void sendTo(EntityPlayerMP player) {
        NBTTagCompound compound = new NBTTagCompound();
        for (Field field : data) {
            String key = field.getName();
            try {
                Object value = field.get(CustomNpcs.instance);
                if (value instanceof int[]) {
                    compound.func_74783_a(key, (int[])value);
                    continue;
                }
                if (value instanceof Color[]) {
                    int[] colors = new int[((Color[])value).length];
                    for (int i = 0; i < colors.length; ++i) {
                        colors[i] = ((Color[])value)[i].getRGB();
                    }
                    compound.func_74783_a(key, colors);
                    continue;
                }
                if (value instanceof Boolean) {
                    compound.func_74757_a(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    compound.func_74768_a(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Color) {
                    compound.func_74768_a(key, ((Color)value).getRGB());
                    continue;
                }
                if (value instanceof String) {
                    compound.func_74778_a(key, (String)value);
                    continue;
                }
                LogWriter.warn("Custom object " + key + " = " + value.getClass());
            }
            catch (Exception value) {}
        }
        if (compound.func_150296_c().isEmpty()) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (Class<?> cls : ScriptController.forgeEventNames.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Name", ScriptController.forgeEventNames.get(cls));
            nbt.func_74778_a("Class", cls.getName());
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("ForgeEventNames", (NBTBase)list);
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.ModData, compound});
    }

    public static void load(NBTTagCompound compound) {
        ScriptController.forgeEventNames.clear();
        for (int i = 0; i < compound.func_150295_c("ForgeEventNames", 10).func_74745_c(); ++i) {
            NBTTagCompound nbt = compound.func_150295_c("ForgeEventNames", 10).func_150305_b(i);
            String name = nbt.func_74779_i("Name");
            Class<?> cls = null;
            try {
                cls = Class.forName(nbt.func_74779_i("Class"));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            ScriptController.forgeEventNames.put(cls, name);
        }
        compound.func_82580_o("ForgeEventNames");
        for (String key : compound.func_150296_c()) {
            Field field = null;
            for (Field f : data) {
                if (!f.getName().equals(key)) continue;
                field = f;
                break;
            }
            if (field == null) continue;
            byte id = compound.func_74781_a(key).func_74732_a();
            try {
                if (id == 1) {
                    field.set(null, compound.func_74767_n(key));
                    continue;
                }
                if (id == 3) {
                    if (field.getType() == Color.class) {
                        field.set(null, new Color(compound.func_74762_e(key)));
                        continue;
                    }
                    field.set(null, compound.func_74762_e(key));
                    continue;
                }
                if (id == 8) {
                    field.set(null, compound.func_74779_i(key));
                    continue;
                }
                if (id != 11) continue;
                if (field.getType() == Color[].class) {
                    int[] arr = compound.func_74759_k(key);
                    Color[] colors = new Color[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        colors[i] = new Color(arr[i]);
                    }
                    field.set(null, colors);
                    continue;
                }
                field.set(null, compound.func_74759_k(key));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    public List<IConfigElement> getChildElements() {
        Iterator pI = this.config.getCategory("general").getOrderedValues().iterator();
        TreeMap<String, ConfigElement> map = new TreeMap<String, ConfigElement>();
        while (pI.hasNext()) {
            Property p = (Property)pI.next();
            map.put(p.getName(), new ConfigElement(p));
        }
        for (Property p : this.config.getCategory("client").getOrderedValues()) {
            map.put(p.getName(), new ConfigElement(p));
        }
        return new ArrayList<IConfigElement>(map.values());
    }

    public void resetConfig() {
        for (Field field : CustomNpcs.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProp.class)) continue;
            ConfigProp prop = field.getAnnotation(ConfigProp.class);
            String name = field.getName();
            ConfigCategory cat = this.config.getCategory(prop.type());
            Property property = null;
            String classType = field.getType().getTypeName().toLowerCase().replace("integer", "int").replace("[]", "");
            if (classType.lastIndexOf(".") != -1) {
                classType = classType.substring(classType.lastIndexOf(".") + 1);
            }
            Object object = null;
            try {
                object = field.get(null);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            Property.Type type = Property.Type.STRING;
            if (field.getType().isArray()) {
                String[] values = null;
                String[] validValues = prop.def().split(",");
                switch (classType) {
                    case "string": {
                        values = (String[])object;
                        break;
                    }
                    case "int": {
                        int i;
                        type = Property.Type.INTEGER;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (int[])object;
                        values = new String[vs.length];
                        for (i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "boolean": {
                        int i;
                        type = Property.Type.BOOLEAN;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (boolean[])object;
                        values = new String[vs.length];
                        for (i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "double": {
                        int i;
                        type = Property.Type.DOUBLE;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (double[])object;
                        values = new String[vs.length];
                        for (i = 0; i < vs.length; ++i) {
                            values[i] = "" + vs[i];
                        }
                        break;
                    }
                    case "color": {
                        int i;
                        type = Property.Type.COLOR;
                        if (object == null) {
                            values = validValues;
                            break;
                        }
                        Object[] vs = (Color[])object;
                        values = new String[vs.length];
                        for (i = 0; i < vs.length; ++i) {
                            values[i] = Integer.toHexString(vs[i].getRGB()).toUpperCase();
                            if (vs[i].getAlpha() != 0) continue;
                            int n = i;
                            values[n] = values[n] + -16777216;
                        }
                        break;
                    }
                }
                if (values != null) {
                    property = new Property(name, values, type, "config." + name + ".key");
                    property.setValidValues(validValues);
                    if (!prop.min().isEmpty()) {
                        if (classType.equals("int")) {
                            property.setMinValue(Integer.parseInt(prop.min()));
                        } else if (classType.equals("double")) {
                            property.setMinValue(Double.parseDouble(prop.min()));
                        }
                    }
                    if (!prop.max().isEmpty()) {
                        if (classType.equals("int")) {
                            property.setMaxValue(Integer.parseInt(prop.max()));
                        } else if (classType.equals("double")) {
                            property.setMaxValue(Double.parseDouble(prop.max()));
                        }
                    }
                }
            } else if (object != null) {
                String value = object.toString();
                switch (classType) {
                    case "int": {
                        type = Property.Type.INTEGER;
                        value = object.toString();
                        break;
                    }
                    case "boolean": {
                        type = Property.Type.BOOLEAN;
                        value = object.toString();
                        break;
                    }
                    case "double": {
                        type = Property.Type.DOUBLE;
                        value = object.toString();
                        break;
                    }
                    case "color": {
                        type = Property.Type.COLOR;
                        value = Integer.toHexString(((Color)object).getRGB()).toUpperCase();
                    }
                }
                property = new Property(name, value, type, "config." + name + ".key");
                property.setDefaultValue(prop.def());
                if (!prop.min().isEmpty()) {
                    if (classType.equals("int")) {
                        property.setMinValue(Integer.parseInt(prop.min()));
                    } else if (classType.equals("double")) {
                        property.setMinValue(Double.parseDouble(prop.min()));
                    }
                }
                if (!prop.max().isEmpty()) {
                    if (classType.equals("int")) {
                        property.setMaxValue(Integer.parseInt(prop.max()));
                    } else if (classType.equals("double")) {
                        property.setMaxValue(Double.parseDouble(prop.max()));
                    }
                }
            }
            if (property == null) continue;
            if (!prop.info().isEmpty()) {
                property.setComment(prop.info());
            }
            cat.put(name, property);
        }
        this.config.save();
    }

    public void resetData() {
        boolean needResetConfig = false;
        for (Field field : CustomNpcs.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigProp.class)) continue;
            ConfigProp prop = field.getAnnotation(ConfigProp.class);
            if (prop.type().equals("general")) {
                data.add(field);
            }
            String name = field.getName();
            ConfigCategory cat = this.config.getCategory(prop.type());
            if (!cat.containsKey(name)) continue;
            Property property = cat.get(name);
            Property.Type type = property.getType();
            if (field.getType().isArray()) {
                String[] values = property.getValidValues();
                try {
                    Object[] vs;
                    Object[] newBase;
                    String[] bd;
                    Object[] vs2;
                    Object[] newBase2;
                    int i;
                    String[] bd2;
                    Object[] min;
                    if (type == Property.Type.STRING) {
                        field.set(null, values);
                        continue;
                    }
                    if (type == Property.Type.INTEGER) {
                        int[] base = (int[])field.get(null);
                        int[] def = null;
                        min = null;
                        int[] max = null;
                        if (!prop.def().isEmpty()) {
                            bd2 = prop.def().split(",");
                            def = new int[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                def[i] = Integer.parseInt(bd2[i]);
                            }
                        }
                        if (!prop.min().isEmpty()) {
                            bd2 = prop.min().split(",");
                            min = new int[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                min[i] = Integer.parseInt(bd2[i]);
                            }
                        }
                        if (!prop.max().isEmpty()) {
                            bd2 = prop.max().split(",");
                            max = new int[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                max[i] = Integer.parseInt(bd2[i]);
                            }
                        }
                        if (def != null && base.length != def.length) {
                            newBase2 = new int[def.length];
                            for (i = 0; i < def.length; ++i) {
                                newBase2[i] = i < base.length ? base[i] : def[i];
                            }
                            base = newBase2;
                            needResetConfig = true;
                        }
                        vs2 = new int[base.length];
                        for (i = 0; i < values.length && i < base.length; ++i) {
                            vs2[i] = Integer.parseInt(values[i]);
                            if (min != null && i < min.length && vs2[i] < min[i]) {
                                vs2[i] = min[i];
                                needResetConfig = true;
                            }
                            if (max == null || i >= max.length || vs2[i] <= max[i]) continue;
                            vs2[i] = max[i];
                            needResetConfig = true;
                        }
                        field.set(null, vs2);
                        continue;
                    }
                    if (type == Property.Type.BOOLEAN) {
                        boolean[] base = (boolean[])field.get(null);
                        boolean[] def = null;
                        if (!prop.def().isEmpty()) {
                            bd = prop.def().split(",");
                            def = new boolean[bd.length];
                            for (int i2 = 0; i2 < bd.length; ++i2) {
                                def[i2] = Boolean.parseBoolean(bd[i2]);
                            }
                        }
                        if (def != null && base.length != def.length) {
                            newBase = new boolean[def.length];
                            for (int i3 = 0; i3 < def.length; ++i3) {
                                newBase[i3] = i3 < base.length ? base[i3] : def[i3];
                            }
                            base = newBase;
                            needResetConfig = true;
                        }
                        vs = new boolean[values.length];
                        for (int i4 = 0; i4 < values.length && i4 < base.length; ++i4) {
                            vs[i4] = Boolean.parseBoolean(values[i4]);
                        }
                        field.set(null, vs);
                        continue;
                    }
                    if (type == Property.Type.DOUBLE) {
                        Object[] base = (double[])field.get(null);
                        double[] def = null;
                        min = null;
                        double[] max = null;
                        if (!prop.def().isEmpty()) {
                            bd2 = prop.def().split(",");
                            def = new double[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                def[i] = Double.parseDouble(bd2[i]);
                            }
                        }
                        if (!prop.min().isEmpty()) {
                            bd2 = prop.min().split(",");
                            min = new double[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                min[i] = (int)Double.parseDouble(bd2[i]);
                            }
                        }
                        if (!prop.max().isEmpty()) {
                            bd2 = prop.max().split(",");
                            max = new double[bd2.length];
                            for (i = 0; i < bd2.length; ++i) {
                                max[i] = Double.parseDouble(bd2[i]);
                            }
                        }
                        if (def != null && base.length != def.length) {
                            newBase2 = new double[def.length];
                            for (i = 0; i < def.length; ++i) {
                                newBase2[i] = (int)(i < base.length ? base[i] : def[i]);
                            }
                            base = newBase2;
                            needResetConfig = true;
                        }
                        vs2 = new double[values.length];
                        for (i = 0; i < values.length && i < base.length; ++i) {
                            vs2[i] = (int)Double.parseDouble(values[i]);
                            if (min != null && i < min.length && vs2[i] < min[i]) {
                                vs2[i] = min[i];
                                needResetConfig = true;
                            }
                            if (max == null || i >= max.length || !(vs2[i] > max[i])) continue;
                            vs2[i] = (int)max[i];
                            needResetConfig = true;
                        }
                        field.set(null, vs2);
                        continue;
                    }
                    if (type != Property.Type.COLOR) continue;
                    Object[] base = (Color[])field.get(null);
                    Color[] def = null;
                    if (!prop.def().isEmpty()) {
                        bd = prop.def().split(",");
                        def = new Color[bd.length];
                        for (int i5 = 0; i5 < bd.length; ++i5) {
                            def[i5] = new Color((int)Long.parseLong(bd[i5], 16));
                        }
                    }
                    if (def != null && base.length != def.length) {
                        newBase = new Color[def.length];
                        for (int i6 = 0; i6 < def.length; ++i6) {
                            newBase[i6] = i6 < base.length ? base[i6] : def[i6];
                        }
                        base = newBase;
                        needResetConfig = true;
                    }
                    vs = new Color[values.length];
                    for (int i7 = 0; i7 < values.length && i7 < base.length; ++i7) {
                        try {
                            vs[i7] = new Color(Integer.parseInt(values[i7]));
                            continue;
                        }
                        catch (Exception e) {
                            vs[i7] = new Color((int)Long.parseLong(values[i7], 16));
                            vs[i7] = new Color(vs[i7].getRed(), vs[i7].getGreen(), vs[i7].getBlue(), 0);
                        }
                    }
                    field.set(null, vs);
                }
                catch (Exception e) {
                    LogWriter.error("Config Error field \"" + name + "\"; type: " + type, e);
                }
                continue;
            }
            try {
                if (type == Property.Type.STRING) {
                    field.set(null, property.getString());
                    continue;
                }
                if (type == Property.Type.INTEGER) {
                    int n;
                    int m;
                    int v = Integer.parseInt(property.getString());
                    if (!prop.min().isEmpty() && v < (m = Integer.parseInt(prop.min()))) {
                        v = m;
                    }
                    if (!prop.max().isEmpty() && v > (n = Integer.parseInt(prop.max()))) {
                        v = n;
                    }
                    field.set(null, v);
                    continue;
                }
                if (type == Property.Type.BOOLEAN) {
                    field.set(null, Boolean.valueOf(property.getString()));
                    continue;
                }
                if (type == Property.Type.DOUBLE) {
                    double n;
                    double m;
                    double v = Double.parseDouble(property.getString());
                    if (!prop.min().isEmpty() && v < (m = Double.parseDouble(prop.min()))) {
                        v = m;
                    }
                    if (!prop.max().isEmpty() && v > (n = Double.parseDouble(prop.max()))) {
                        v = n;
                    }
                    field.set(null, v);
                    continue;
                }
                if (type != Property.Type.COLOR) continue;
                Color color = new Color((int)Long.parseLong(property.getString(), 16));
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
                field.set(null, color);
            }
            catch (Exception e) {
                LogWriter.error("Config Error field \"" + name + "\"; type: " + type, e);
            }
        }
        if (needResetConfig) {
            this.resetConfig();
        }
    }
}

